import * as userService from '../services/userService.js';

export async function userSignUp(req, res, next) {
    try {
        const { user, token } = await userService.signUp(req.body);

        res.cookie('userToken', token, {
            httpOnly: true,
            secure: process.env.NODE_ENV === 'production',
            sameSite: 'Strict',
            maxAge: 7 * 24 * 60 * 60 * 1000,
        });

        res.status(201).json({
            success: true,
            message: 'User registered successfully',
            data: { userId: user._id },
        });
    } catch (err) {
        next(err);
    }
}

export async function userLogin(req, res, next) {
    try {
        const { user, token } = await userService.login(req.body);

        res.cookie('userToken', token, {
            httpOnly: true,
            secure: process.env.NODE_ENV === 'production',
            sameSite: 'Strict',
            maxAge: 7 * 24 * 60 * 60 * 1000,
        });

        res.status(200).json({
            success: true,
            message: 'Login successful',
            data: { userId: user._id },
        });
    } catch (err) {
        next(err);
    }
}

export async function userLogout(req, res, next) {
    try {
        res.clearCookie('userToken');
        res.status(200).json({ success: true, message: 'User logged out successfully' });
    } catch (err) {
        next(err);
    }
}
