import express from "express";
import {
    createCategoryController,
    getAllCategoryController,
    getCategoryByIdController,
    updatedCategoryController,
    deleteCategoryController,
} from "../controllers/categoryControllers.js";

import { makeUpLoader } from "../middlewares/uploads.js";

const categoryRouter = express.Router();

/* CREATE */
categoryRouter.post(
    "/createCategory",
    makeUpLoader("category", "image", "single"),
    createCategoryController
);

/* GET ALL */
categoryRouter.get("/allcategory", getAllCategoryController);

/* GET BY ID */
categoryRouter.get("/:id", getCategoryByIdController);

/* UPDATE */
categoryRouter.put(
    "/updateCategory/:id",
    makeUpLoader("category", "image", "single"),
    updatedCategoryController
);

/* DELETE */
categoryRouter.delete("/deleteCategory/:id", deleteCategoryController);

export default categoryRouter;
