import express from "express";
import {
    createProductController,
    getAllProductsController,
    getProductIdController,
    updateProductController,
    deleteProductController,
    getInfoLibraryController,
    saveInfoLibraryController,
} from "../controllers/productControllers.js";

import { makeUpLoader } from "../middlewares/uploads.js";
import { getProductsByCategoryController } from "../controllers/categoryControllers.js";

const ProductRouter = express.Router();

/* CREATE PRODUCT */
ProductRouter.post(
    "/createproduct",
    makeUpLoader("products", "media", "array", 10),
    createProductController
);

/* GET ALL PRODUCTS (with pagination + sorting) */
ProductRouter.get("/allproducts", getAllProductsController);

/* GET PRODUCT BY ID */
ProductRouter.get("/allproduct/:id", getProductIdController);

/* UPDATE PRODUCT */
ProductRouter.put(
    "/editproduct/:id",
    makeUpLoader("products", "media", "array", 10),
    updateProductController
);

/* DELETE PRODUCT */
ProductRouter.delete("/removeproduct/:id", deleteProductController);

/* INFO LIBRARY */
ProductRouter.get("/infosection-library", getInfoLibraryController);
ProductRouter.post("/infosection-library", saveInfoLibraryController);

ProductRouter.get("/category/:id",getProductsByCategoryController)

export default ProductRouter;
