// src/App.jsx
import { BrowserRouter as Router, Routes, Route, useLocation } from "react-router-dom";
import { Toaster } from "sonner";
import { AuthProvider } from "./context/AuthContext";

/* ------------------ PUBLIC COMPONENTS ------------------ */
import Navbar from "./components/Navbar/Navbar";
import Categories from "./components/Categories/Categories";
import Slider from "./components/Slider/Slider";
import Offers from "./components/Offers/Offers";
import Footer from "./components/Footer/Footer";
import BecomeASeller from "./components/BecomeASeller/BecomeASeller";
import FeeAndCom from "./components/BecomeASeller/FeeAndCom";
import Grow from "./components/BecomeASeller/Grow";
import Learn from "./components/BecomeASeller/Learn";
import StartSelling from "./components/BecomeASeller/StartSelling";
import StepEmailGst from "./components/BecomeASeller/StepEmailGst";
import StepOnboarding from "./components/BecomeASeller/StepOnboarding";
import StepPasswordCreation from "./components/BecomeASeller/StepPasswordCreation";
import OnboardingSuccess from "./components/BecomeASeller/OnboardingSuccess";
import TermsAndPolicy from "./components/BecomeASeller/TermsAndPolicy";
import LoginPage from "./components/LoginPage/LoginPage";
import Profile from "./components/Profile/Profile";


/* ------------------ ADMIN COMPONENTS ------------------ */
import AdminLogin from "./admin/auth/AdminLogin";
import AdminLayout from "./admin/components/AdminLayout";

import AdminDashboard from "./admin/pages/AdminDashboard";
import AdminOrders from "./admin/pages/AdminOrders";
import AdminUsers from "./admin/pages/AdminUsers";
import AdminVendors from "./admin/pages/AdminVendors";

/* ------------------ ADMIN PRODUCT MODULE ------------------ */
import ProductManagement from "./admin/pages/Catalog/products/ProductManagement";
import ImportProducts from "./admin/pages/Catalog/products/ImportProducts";
import NewPhysicalProduct from "./admin/pages/Catalog/products/newPhysicalProduct/NewPhysicalProduct";

/* ------------------ ADMIN CATEGORY MODULE ------------------ */
import ProductCategories from "./admin/pages/Catalog/categories/ProductCategories";
import NewCategory from "./admin/pages/Catalog/categories/NewCategory";
import UserProductPage from "./components/productPage/UserProductPage";
import SingleProductPage from './components/productPage/singleProductPage/SingleProductPage'

/* ------------------ PUBLIC ROUTES TO HIDE NAVBAR/FOOTER ------------------ */
const HIDE_NAVBAR_PATHS = [
  "/becomeaseller",
  "/feeandcom",
  "/grow",
  "/learn",
  "/terms-privacy",
];

const AppContent = () => {
  const location = useLocation();
  const path = location.pathname.toLowerCase();

  const isAdmin = path.startsWith("/admin");
  const hideNavbar = isAdmin || HIDE_NAVBAR_PATHS.includes(path);
  const hideFooter = isAdmin;

  return (
    <>
      {/* Toast Notifications */}
      <Toaster position="top-right" richColors />

      {/* Navbar (auto-hidden on admin pages) */}
      {!hideNavbar && <Navbar />}

      <Routes>
        {/* ---------------- PUBLIC ROUTES ---------------- */}
        <Route
          path="/"
          element={
            <>
              <Categories />
              <Slider />
              <Offers />
            </>
          }
        />

        {/* User Product page */}
        <Route path="/category/:slug/:id" element={<UserProductPage />} />
        <Route path="/product/:id" element={<SingleProductPage />} />

        {/* Become a Seller Flow */}
        <Route path="/learn" element={<Learn />} />
        <Route path="/grow" element={<Grow />} />
        <Route path="/becomeaseller" element={<BecomeASeller />} />
        <Route path="/feeandcom" element={<FeeAndCom />} />
        <Route path="/startselling" element={<StartSelling />} />
        <Route path="/stepemailgst" element={<StepEmailGst />} />
        <Route path="/steponboarding" element={<StepOnboarding />} />
        <Route path="/steppasswordcreation" element={<StepPasswordCreation />} />
        <Route path="/onboarding-success" element={<OnboardingSuccess />} />
        <Route path="/terms-privacy" element={<TermsAndPolicy />} />

        {/* User Auth */}
        <Route path="/userlogin" element={<LoginPage />} />
        <Route path="/usersignup" element={<LoginPage />} />
        <Route path="/userprofile" element={<Profile />} />

        {/* ---------------- ADMIN ROUTES ---------------- */}
        <Route path="/admin/login" element={<AdminLogin />} />

        {/* Protected Admin Area */}
        <Route path="/admin" element={<AdminLayout />}>
          {/* Admin Dashboard */}
          <Route path="dashboard" element={<AdminDashboard />} />
          <Route path="orders" element={<AdminOrders />} />
          <Route path="users" element={<AdminUsers />} />
          <Route path="vendors" element={<AdminVendors />} />

          {/* PRODUCTS */}
          <Route path="products">
            <Route index element={<ProductManagement />} />
            <Route path="import" element={<ImportProducts />} />
            <Route path="newproducts" element={<NewPhysicalProduct />} />
            {/* <Route path="productcategory" element={<ProductCategory />} /> */}
            <Route path="newcategory" element={<NewCategory />} />
          </Route>

          {/* ✅ CATEGORIES */}
          <Route path="category">
            <Route index element={<ProductCategories />} />        {/* /admin/category */}
            <Route path="new" element={<NewCategory />} />          {/* /admin/category/new */}
            <Route path="edit/:id" element={<NewCategory />} />     {/* /admin/category/edit/:id */}
          </Route>
        </Route>
      </Routes>

      {/* Footer (hidden on admin pages) */}
      {!hideFooter && <Footer />}
    </>
  );
};

/* ------------------ MAIN APP WRAPPER ------------------ */
const App = () => (
  <AuthProvider>
    <Router>
      <AppContent />
    </Router>
  </AuthProvider>
);

export default App;
