import { Outlet } from "react-router-dom";
import AdminSidebar from "./AdminSidebar";
import AdminNavbar from "./AdminNavbar";

export default function AdminLayout() {
  return (
    <div className="min-h-screen bg-gray-50">
      {/* ✅ Navbar full width at top */}
      <header className="fixed top-0 left-0 right-0 z-50">
        <AdminNavbar />
      </header>

      <div className="flex pt-16"> {/* push content below navbar */}
        {/* ✅ Sidebar starts below navbar */}
        <aside className="fixed top-16 left-0 h-[calc(100vh-4rem)] w-64 bg-white shadow-md z-40 overflow-y-auto">
          <AdminSidebar />
        </aside>

        {/* ✅ Main content beside sidebar */}
        <main className="flex-1 ml-64 p-8">
          <Outlet />
        </main>
      </div>
    </div>
  );
}
