import React, { useState } from "react";
import { MoreVertical, Edit3, StopCircle } from "lucide-react";
import { useNavigate } from "react-router-dom";

export default function Inventory() {
  const navigate = useNavigate();
  const [filter, setFilter] = useState("All");
  const [menuOpen, setMenuOpen] = useState(null);

  const [inventoryData, setInventoryData] = useState([
    {
      id: 1,
      image: "https://via.placeholder.com/60",
      name: "100",
      sku: "—",
      inventory: 0,
      status: "Out of stock",
    },
    {
      id: 2,
      image: "https://i.ibb.co/Kp9yYF4/Baseball-Cap.png",
      name: "Baseball Cap",
      sku: "632835642834572",
      inventory: 12,
      status: "In stock",
    },
    {
      id: 3,
      image: "https://i.ibb.co/zWZBn3Zm/Vase.png",
      name: "Ceramic Flower Vase",
      sku: "364215376135191",
      inventory: 10,
      status: "In stock",
    },
    {
      id: 4,
      image: "https://i.ibb.co/r2Dz0ZCN/Tshirt.png",
      name: "Crew T-Shirt",
      sku: "21554345656",
      inventory: 20,
      status: "In stock",
    },
  ]);

  // ✅ Stop tracking logic
  const handleStopTracking = (id) => {
    setInventoryData((prev) =>
      prev.map((item) =>
        item.id === id
          ? { ...item, inventory: 0, status: "Out of stock" }
          : item
      )
    );
    setMenuOpen(null);
  };

  // ✅ Filter logic
  const filteredData =
    filter === "In Stock"
      ? inventoryData.filter((item) => item.status === "In stock")
      : filter === "Out of Stock"
<<<<<<< HEAD
      ? inventoryData.filter((item) => item.status === "Out of stock")
      : inventoryData;
=======
        ? inventoryData.filter((item) => item.status === "Out of stock")
        : inventoryData;
>>>>>>> dev

  return (
    <div className="p-6 bg-gray-50 min-h-screen transition-all duration-500">
      {/* ===== Header ===== */}
      <div className="flex justify-between items-center mb-6">
        <div>
          <h1 className="text-3xl font-bold text-slate-800">
            Inventory <span className="text-gray-400 text-2xl">({filteredData.length})</span>
          </h1>
          <p className="text-gray-500">
            Your inventory updates whenever an order is placed.{" "}
            <span className="text-orange-600 cursor-pointer hover:underline">
              Change this setting
            </span>
          </p>
        </div>

        <button className="px-4 py-2 bg-orange-100 hover:bg-orange-200 text-gray-800 rounded-full font-semibold transition-all">
          View Detailed Report →
        </button>
      </div>

      {/* ===== Filter Section ===== */}
      <div className="flex items-center justify-between bg-white p-4 rounded-t-xl shadow-sm border border-gray-200">
        <div className="flex items-center gap-3">
          <label className="text-gray-600 font-medium">Filter by:</label>
          <select
            className="border border-gray-300 rounded-lg px-3 py-2 focus:ring-2 focus:ring-orange-400"
            value={filter}
            onChange={(e) => setFilter(e.target.value)}
          >
            <option>All</option>
            <option>In Stock</option>
            <option>Out of Stock</option>
          </select>
        </div>
      </div>

      {/* ===== Inventory Table ===== */}
      <div className="bg-white border-x border-b border-gray-200 rounded-b-xl overflow-hidden">
        <table className="w-full text-left">
          <thead className="bg-orange-50 border-b border-gray-200">
            <tr>
              <th className="p-4">
                <input type="checkbox" />
              </th>
              <th className="p-4 font-semibold text-gray-700">Name</th>
              <th className="p-4 font-semibold text-gray-700">SKU</th>
              <th className="p-4 font-semibold text-gray-700">Inventory</th>
              <th className="p-4"></th>
            </tr>
          </thead>

          <tbody>
            {filteredData.map((item) => (
              <tr
                key={item.id}
                className="border-b border-gray-100 hover:bg-orange-50 transition-all duration-300"
              >
                <td className="p-4">
                  <input type="checkbox" />
                </td>

                <td className="p-4 flex items-center gap-3">
                  <img
                    src={item.image}
                    alt={item.name}
                    className="w-10 h-10 rounded-full border border-gray-200 object-cover"
                  />
                  <span className="font-medium text-gray-800">{item.name}</span>
                </td>

                <td className="p-4 text-gray-600">{item.sku}</td>

                <td className="p-4">
                  {item.status === "In stock" ? (
                    <select className="border border-orange-300 rounded-lg px-3 py-1 text-gray-700 focus:ring-1 focus:ring-orange-400">
                      <option>In stock</option>
                      <option>Out of stock</option>
                    </select>
                  ) : (
                    <input
                      type="number"
                      value={item.inventory}
                      className="border border-gray-300 rounded-lg px-2 py-1 w-16 text-center text-gray-700"
                      readOnly
                    />
                  )}
                </td>

                {/* ⋮ Menu */}
                <td className="p-4 text-right relative">
                  <button
                    className="hover:bg-orange-100 rounded-full p-2 transition"
                    onClick={() =>
                      setMenuOpen(menuOpen === item.id ? null : item.id)
                    }
                  >
                    <MoreVertical size={18} className="text-gray-600" />
                  </button>

                  {menuOpen === item.id && (
                    <div className="absolute right-4 top-10 bg-white border border-gray-200 shadow-lg rounded-lg w-44 animate-fadeIn z-10">
                      <button
                        onClick={() => {
<<<<<<< HEAD
                          navigate("/admin /products/newproducts");
=======
                          navigate("/admin/products/newproducts");
>>>>>>> dev
                          setMenuOpen(null);
                        }}
                        className="flex items-center gap-2 px-4 py-2 w-full text-gray-700 text-sm hover:bg-orange-50 transition"
                      >
                        <Edit3 size={16} className="text-orange-500" />
                        Edit Product
                      </button>

                      <button
                        onClick={() => handleStopTracking(item.id)}
                        className="flex items-center gap-2 px-4 py-2 w-full text-gray-700 text-sm hover:bg-orange-100 transition"
                      >
                        <StopCircle size={16} className="text-orange-500" />
                        Stop Tracking
                      </button>
                    </div>
                  )}
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>

      <style jsx>{`
        @keyframes fadeIn {
          from {
            opacity: 0;
            transform: translateY(-5px);
          }
          to {
            opacity: 1;
            transform: translateY(0);
          }
        }
        .animate-fadeIn {
          animation: fadeIn 0.25s ease-in-out;
        }
      `}</style>
    </div>
  );
}
