import { useState } from "react";
import { X } from "lucide-react";

export default function ExportProductsModal({ onClose, onExport }) {
    const [selectedOption, setSelectedOption] = useState("all");

    const handleExport = () => {
        onExport(selectedOption);
        onClose();
    };

    return (
        <div className="fixed inset-0 bg-black bg-opacity-40 flex items-center justify-center z-50">
            <div className="bg-white rounded-xl shadow-lg w-full max-w-md p-6">
                {/* Header */}
                <div className="flex justify-between items-center mb-4">
                    <h2 className="text-lg font-semibold">
                        Which items do you want to export?
                    </h2>
                    <button
                        onClick={onClose}
                        className="p-1 text-gray-500 hover:text-gray-700"
                    >
                        <X className="w-5 h-5" />
                    </button>
                </div>

                {/* Options */}
                <div className="space-y-3 mb-6">
                    <label className="flex items-center gap-3 cursor-pointer">
                        <input
                            type="radio"
                            name="exportType"
                            value="all"
                            checked={selectedOption === "all"}
                            onChange={(e) => setSelectedOption(e.target.value)}
                            className="text-blue-600 focus:ring-blue-500"
                        />
                        <span className="text-gray-800">All</span>
                    </label>

                    <label className="flex items-center gap-3 cursor-pointer">
                        <input
                            type="radio"
                            name="exportType"
                            value="filtered"
                            checked={selectedOption === "filtered"}
                            onChange={(e) => setSelectedOption(e.target.value)}
                            className="text-blue-600 focus:ring-blue-500"
                        />
                        <span className="text-gray-800">Filtered (0)</span>
                    </label>

                    <label className="flex items-center gap-3 cursor-pointer">
                        <input
                            type="radio"
                            name="exportType"
                            value="selected"
                            checked={selectedOption === "selected"}
                            onChange={(e) => setSelectedOption(e.target.value)}
                            className="text-blue-600 focus:ring-blue-500"
                        />
                        <span className="text-gray-800">Selected (0)</span>
                    </label>
                </div>

                {/* Description */}
                <p className="text-sm text-gray-600 mb-6">
                    Your items and all their data will be downloaded as a CSV file.
                </p>

                {/* Footer */}
                <div className="flex justify-end gap-3">
                    <button
                        onClick={onClose}
                        className="px-4 py-2 rounded-md bg-gray-100 text-gray-700 hover:bg-gray-200"
                    >
                        Cancel
                    </button>
                    <button
                        onClick={handleExport}
                        className="px-4 py-2 rounded-md bg-blue-600 text-white hover:bg-blue-700"
                    >
                        Export
                    </button>
                </div>

                <p className="text-xs text-gray-500 mt-4">
                    Note: Digital products are not exported.
                </p>
            </div>
        </div>
    );
}
