import { Info } from "lucide-react";

export default function BasicInfo({
    title,
    setTitle,
    ribbon,
    setRibbon,
    brand,
    setBrand,
    rating,
    setRating,
    reviewsCount,
    setReviewsCount,
}) {
    return (
        <section className="bg-white rounded-xl shadow-sm p-6 border border-gray-100">
            {/* ---------------- HEADER ---------------- */}
            <h2 className="text-2xl font-semibold mb-4">Basic Info</h2>
            <hr className="mb-4" />

            {/* ---------------- PRODUCT NAME ---------------- */}
            <div className="mb-5">
                <label className="text-sm font-medium text-slate-700 flex items-center gap-1">
                    Product Name <span className="text-red-500">*</span>
                    <Info className="w-4 h-4 text-orange-500" />
                </label>
                <input
                    type="text"
                    value={title}
                    onChange={(e) => setTitle(e.target.value)}
                    className="w-full border rounded-lg px-3 py-2 mt-1 text-gray-800 focus:ring-2 focus:ring-orange-400 outline-none"
                    placeholder="Enter product name"
                />
            </div>

            {/* ---------------- RIBBON & BRAND ---------------- */}
            <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
                {/* Ribbon */}
                <div>
                    <label className="text-sm font-medium text-slate-700">
                        Ribbon
                    </label>
                    <select
                        value={ribbon}
                        onChange={(e) => setRibbon(e.target.value)}
                        className="w-full border rounded-lg px-3 py-2 mt-1 bg-white focus:ring-2 focus:ring-orange-400 outline-none"
                    >
                        <option value="">Select ribbon</option>
                        <option>New</option>
                        <option>Sale</option>
                        <option>Limited Edition</option>
                        <option>Trending</option>
                        <option>Best Seller</option>
                        <option>Top Rated</option>
                    </select>
                </div>

                {/* Brand */}
                <div>
                    <label className="text-sm font-medium text-slate-700">
                        Brand
                    </label>
                    <input
                        type="text"
                        value={brand}
                        onChange={(e) => setBrand(e.target.value)}
                        className="w-full border rounded-lg px-3 py-2 mt-1 text-gray-800 focus:ring-2 focus:ring-orange-400 outline-none"
                        placeholder="Enter brand name"
                    />
                </div>
            </div>

            {/* ---------------- RATING & REVIEWS ---------------- */}
            <div className="grid grid-cols-1 md:grid-cols-2 gap-4 mt-6">
                {/* Rating */}
                <div>
                    <label className="text-sm font-medium text-slate-700">
                        Rating (1 - 5)
                    </label>
                    <input
                        type="number"
                        min="1"
                        max="5"
                        step="0.1"
                        value={rating}
                        onChange={(e) => {
                            const val = Math.min(5, Math.max(1, Number(e.target.value)));
                            setRating(val);
                        }}
                        className="w-full border rounded-lg px-3 py-2 mt-1 text-gray-800 focus:ring-2 focus:ring-orange-400 outline-none"
                        placeholder="4.5"
                    />
                    <p className="text-xs text-gray-500 mt-1">
                        Average product rating shown on the product page.
                    </p>
                </div>

                {/* Reviews Count */}
                <div>
                    <label className="text-sm font-medium text-slate-700">
                        Reviews Count
                    </label>
                    <input
                        type="number"
                        min="0"
                        value={reviewsCount}
                        onChange={(e) => setReviewsCount(Number(e.target.value))}
                        className="w-full border rounded-lg px-3 py-2 mt-1 text-gray-800 focus:ring-2 focus:ring-orange-400 outline-none"
                        placeholder="120"
                    />
                    <p className="text-xs text-gray-500 mt-1">
                        Number of customer reviews visible to users.
                    </p>
                </div>
            </div>
        </section>
    );
}
