import ReactQuill from "react-quill-new";
import "react-quill-new/dist/quill.snow.css";

export default function DescriptionEditor({ description, setDescription }) {
    return (
        <section className="bg-white rounded-xl shadow-sm p-6">
            <h2 className="text-2xl font-semibold mb-4">Description</h2>
            <hr className="mb-4" />

            <ReactQuill
                theme="snow"
                value={description}
                onChange={setDescription}
                placeholder="Write a detailed product description..."
                className="min-h-[200px]"
            />
        </section>
    );
}
