import { useNavigate } from "react-router-dom";
import waitingImage from "../../assets/images/waiting.png";

export default function OnboardingSuccess() {
  const navigate = useNavigate();

  return (
    <div className="min-h-screen flex flex-col items-center justify-center bg-orange-50 text-center p-6">
      <div className="bg-white shadow-xl rounded-2xl p-10 max-w-md">
        <h1 className="text-3xl text-orange-600 mb-4">
          ⏳ Awaiting Approval
        </h1>
        <p className="text-gray-700 mb-6">
          Your onboarding is complete You will be notified once your account is approved. 
        </p>

        <p>Thank you for your patience!</p>

        {/* Waiting Image */}
        <img
          src={waitingImage}
          alt="Waiting for approval"
          className="w-40 h-40 mx-auto mb-6 object-contain"
        />

        <button
          onClick={() => navigate("/")}
          className="bg-orange-500 text-white px-6 py-2 rounded-md hover:bg-orange-600 transition"
        >
          Next
        </button>
      </div>

      <p className="text-gray-400 text-sm mt-6">
        © {new Date().getFullYear()} E-Sahakara | Empowering Sellers
      </p>
    </div>
  );
}

