import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";

// Import your images
import SELLER0 from "../../assets/images/seller0.png";
import SELLER9 from "../../assets/images/seller9.png";
import SELLER8 from "../../assets/images/seller8.png";

export default function SellerSlide() {
  const sellers = [
    {
      id: 1,
      name: "Amit Sharma",
      story:
        "Amit Sharma, the founder of PureGlow Soaps, used E-Sahakara to expand his business online. The platform’s tools made it easy to list products, reach new customers, and track performance. With E-Sahakara’s insights and support, Amit optimized his sales and grew his brand efficiently. Today, his business thrives, connecting with customers across multiple cities, all thanks to E-Sahakara.",
      img: SELLER0,
    },
    {
      id: 2,
      name: "Neha Verma",
      story:
        "Neha started small but dreamed big. By trying new ideas and connecting with her customers, she quickly grew her business and reached buyers in cities she had never imagined. Her passion and dedication made her shop a favorite for many..",
      img: SELLER9,
    },
    {
      id: 3,
      name: "Ravi Kumar",
      story:
        "Ravi started selling fresh farm produce online. By using smart tools to manage his listings and reach more customers, he expanded his brand and brought quality fruits and vegetables to homes across the region.",
      img: SELLER8,
    },
  ];

  return (
    <div className="w-full max-w-full overflow-hidden relative">
      <Swiper
        modules={[Navigation, Pagination, Autoplay]}
        spaceBetween={20}
        slidesPerView={1}
        navigation={{
          nextEl: ".custom-next",
          prevEl: ".custom-prev",
        }}
        pagination={{ clickable: true }}
        autoplay={{ delay: 5000, disableOnInteraction: false }}
        loop={true}
        className="w-full"
      >
        {sellers.map((seller) => (
          <SwiperSlide key={seller.id}>
            <div className="bg-white rounded-lg shadow-md p-6 flex flex-col md:flex-row items-center gap-4 cursor-pointer">
              {seller.img && (
                <img
                  src={seller.img}
                  alt={seller.name}
                  className="w-24 h-24 rounded-full object-cover"
                />
              )}
              <div>
                <h3 className="font-semibold text-lg">{seller.name}</h3>
                <p className="text-gray-700 mt-2">{seller.story}</p>
              </div>
            </div>
          </SwiperSlide>
        ))}
      </Swiper>

      {/* Custom smaller arrows */}
      <div className="custom-prev absolute top-1/2 left-2 -translate-y-1/2 text-gray-700 text-3xl cursor-pointer select-none">
        ‹
      </div>
      <div className="custom-next absolute top-1/2 right-2 -translate-y-1/2 text-gray-700 text-3xl cursor-pointer select-none">
        ›
      </div>
    </div>
  );
}
