import { useState } from "react";
import StepEmailGst from "./StepEmailGst";
import StepPasswordCreation from "./StepPasswordCreation";
import StepOnboarding from "./StepOnboarding";
import OnboardingSuccess from "./OnboardingSuccess";

const StartSelling = () => {
  const steps = [
    "EMAIL ID & GST",
    "PASSWORD CREATION",
    "ONBOARDING DASHBOARD",
  ];
  const [currentStep, setCurrentStep] = useState(1);

  const nextStep = () => setCurrentStep((prev) => prev + 1);
  const prevStep = () => setCurrentStep((prev) => Math.max(prev - 1, 1));

  return (
    <div className="w-screen min-h-screen bg-gray-50 flex flex-col overflow-x-hidden">
      {/* Progress Bar */}
      <div className="w-full bg-white shadow-sm p-6 sticky top-0 z-10 flex justify-center overflow-x-hidden">
        <div className="flex items-center space-x-4">
          {steps.map((step, idx) => {
            const isCompleted = currentStep > idx + 1;
            const isActive = currentStep === idx + 1;

            return (
              <div key={idx} className="flex items-center">
                {/* Number Circle */}
                <div
                  className={`flex items-center justify-center w-8 h-8 rounded-full border-2 text-sm font-semibold transition-all duration-300
                    ${
                      isCompleted
                        ? "bg-orange-500 border-orange-500 text-white"
                        : isActive
                        ? "border-orange-500 text-orange-600"
                        : "border-gray-300 text-gray-400"
                    }`}
                >
                  {idx + 1}
                </div>

                {/* Label */}
                <div
                  className={`ml-2 text-sm font-medium ${
                    isCompleted
                      ? "text-orange-500"
                      : isActive
                      ? "text-orange-600"
                      : "text-gray-500"
                  }`}
                >
                  {step}
                </div>

                {/* Connector Line */}
                {idx < steps.length - 1 && (
                  <div
                    className={`w-10 h-[2px] mx-3 transition-all duration-300 ${
                      isCompleted
                        ? "bg-orange-500"
                        : isActive
                        ? "bg-orange-300"
                        : "bg-gray-300"
                    }`}
                  ></div>
                )}
              </div>
            );
          })}
        </div>
      </div>

      {/* Step Components */}
      <div className="flex-1 w-full overflow-x-hidden">
        {currentStep === 1 && (
          <div className="max-w-3xl w-full mx-auto p-10">
            <StepEmailGst nextStep={nextStep} />
          </div>
        )}
        {currentStep === 2 && (
          <div className="max-w-3xl w-full mx-auto p-10">
            <StepPasswordCreation nextStep={nextStep} prevStep={prevStep} />
          </div>
        )}
        {currentStep === 3 && (
          <div className="max-w-3xl w-full mx-auto p-10">
            <StepOnboarding nextStep={nextStep} prevStep={prevStep} />
          </div>
        )}
        {currentStep === 4 && (
          <div className="max-w-3xl w-full mx-auto p-10">
            <OnboardingSuccess />
          </div>
        )}
      </div>
    </div>
  );
};

export default StartSelling;

