import { useState } from "react";
import { HiOutlineEye, HiOutlineEyeOff } from "react-icons/hi";

const StepEmailGst = ({ nextStep }) => {
  const [otpSent, setOtpSent] = useState(false);
  const [mobile, setMobile] = useState("");
  const [otp, setOtp] = useState("");
  const [email, setEmail] = useState("");
  const [gstin, setGstin] = useState("");
  const [showOtp, setShowOtp] = useState(false);

  const handleSubmit = (e) => {
    e.preventDefault();
    nextStep();
  };

  return (
    <div className="w-full min-h-screen flex justify-center items-start py-10 px-4 overflow-x-hidden bg-gray-50">
      <div className="w-full max-w-md bg-white p-8 rounded-lg shadow-md">
        <h2 className="text-2xl mb-6 text-center text-gray-900">Register Your Account</h2>

        <form onSubmit={handleSubmit} className="flex flex-col">
          {/* Mobile Number */}
          <label className="block mb-1 font-semibold">
            Mobile Number <span className="text-red-500">*</span>
          </label>
          <input
            type="text"
            value={mobile}
            onChange={(e) => setMobile(e.target.value)}
            className="w-full border p-2 rounded mb-4"
            placeholder="Enter mobile number"
            required
          />

          {!otpSent ? (
            <button
              type="button"
              onClick={() => setOtpSent(true)}
              className="w-full bg-orange-500 text-white px-4 py-2 rounded mb-4 hover:bg-orange-600 transition"
            >
              Send OTP
            </button>
          ) : (
            <>
              <label className="block mb-1 font-semibold">
                Enter OTP <span className="text-red-500">*</span>
              </label>
              <div className="relative w-full mb-4">
                <input
                  type={showOtp ? "text" : "password"}
                  value={otp}
                  onChange={(e) => setOtp(e.target.value)}
                  className="w-full border p-2 rounded"
                  placeholder="Enter OTP"
                  required
                />
                <button
                  type="button"
                  onClick={() => setShowOtp(!showOtp)}
                  className="absolute right-2 top-1/2 transform -translate-y-1/2 text-gray-500"
                >
                  {showOtp ? <HiOutlineEyeOff size={20} /> : <HiOutlineEye size={20} />}
                </button>
              </div>
              <p className="text-sm text-gray-500 mb-4">Resend OTP in 2 minutes</p>
            </>
          )}

          {/* Email */}
          <label className="block mb-1 font-semibold">
            Email ID <span className="text-red-500">*</span>
          </label>
          <input
            type="email"
            value={email}
            onChange={(e) => setEmail(e.target.value)}
            className="w-full border p-2 rounded mb-4"
            placeholder="Enter your email"
            required
          />

          {/* GSTIN */}
          <label className="block mb-1 font-semibold">
            Enter GSTIN <span className="text-red-500">*</span>
          </label>
          <input
            type="text"
            value={gstin}
            onChange={(e) => setGstin(e.target.value)}
            className="w-full border p-2 rounded mb-6"
            placeholder="Enter GSTIN"
            required
          />

          {/* Terms */}
          <p className="text-sm text-gray-500 mb-6">
            By continuing, I agree to E-Sahakara's{" "}
            <span className="text-orange-600 underline">Terms of Use</span> &{" "}
            <span className="text-orange-600 underline">Privacy Policy</span>.
          </p>

          {/* Submit */}
          <button
            type="submit"
            className="w-full bg-orange-500 text-white font-semibold px-6 py-2 rounded hover:bg-orange-600 transition"
          >
            Register & Continue →
          </button>
        </form>
      </div>
    </div>
  );
};

export default StepEmailGst;

