import { useState } from "react";
import { HiOutlineEye, HiOutlineEyeOff } from "react-icons/hi"; // eye icons

const StepPasswordCreation = ({ nextStep, prevStep }) => {
  const [fullName, setFullName] = useState("");
  const [displayName, setDisplayName] = useState("");
  const [password, setPassword] = useState("");
  const [showPassword, setShowPassword] = useState(false);

  const handleSubmit = (e) => {
    e.preventDefault();
    nextStep({ fullName, displayName, password });
  };

  return (
    <div className="w-full flex justify-center mt-10">
      <div className="w-full max-w-md p-8 bg-white rounded-lg shadow-md">
        <h2 className="text-2xl font-bold mb-6 text-center text-gray-900">
          
        </h2>

        <form onSubmit={handleSubmit} className="flex flex-col">
          


          {/* Password */}
          <label className="block mb-1 font-semibold">
            Create Password <span className="text-red-500">*</span>
          </label>
          <div className="relative mb-6 w-full max-w-xs">
            <input
              type={showPassword ? "text" : "password"}
              value={password}
              onChange={(e) => setPassword(e.target.value)}
              className="w-full border p-2 rounded"
              placeholder="Enter Password"
              required
            />
            <button
              type="button"
              onClick={() => setShowPassword(!showPassword)}
              className="absolute right-2 top-1/2 transform -translate-y-1/2 text-gray-500"
            >
              {showPassword ? <HiOutlineEyeOff size={20} /> : <HiOutlineEye size={20} />}
            </button>
          </div>

          {/* Full Name */}
          <label className="block mb-1 font-semibold">
            Full Name <span className="text-red-500">*</span>
          </label>
          <input
            type="text"
            value={fullName}
            onChange={(e) => setFullName(e.target.value)}
            className="w-full max-w-xs border p-2 rounded mb-4"
            placeholder="Enter Full Name"
            required
          />

          
          {/* Display Name */}
          <label className="block mb-1 font-semibold">Display Name</label>
          <input
            type="text"
            value={displayName}
            onChange={(e) => setDisplayName(e.target.value)}
            className="w-full max-w-xs border p-2 rounded mb-4"
            placeholder="Enter Display Name"
          />

          {/* Buttons */}
          <div className="flex justify-between w-full max-w-xs">
            <button type="button" onClick={prevStep} className="text-gray-600 hover:underline">
              ← Back
            </button>
            <button
              type="submit"
              className="bg-orange-500 text-white px-6 py-2 rounded hover:bg-orange-600"
            >
              Continue →
            </button>
          </div>
        </form>
      </div>
    </div>
  );
};

export default StepPasswordCreation;
