import { useState } from "react";
import { useNavigate } from "react-router-dom";
import { FaBars, FaTimes } from "react-icons/fa";
import LoginModal from "./LoginModal";
import logoPlain from "../../assets/images/logo_plain.png"; 

const TermsAndPolicy = () => {
  const navigate = useNavigate();
  const [loginOpen, setLoginOpen] = useState(false);
  const [menuOpen, setMenuOpen] = useState(false);

  return (
    <div className="flex flex-col min-h-screen bg-gray-50 font-sans overflow-x-hidden">
      {/* ===== Navbar ===== */}
      <nav className="bg-white text-gray-800 flex items-center justify-between px-6 py-3 shadow-md sticky top-0 z-30">
        {/* Logo */}
        <div
          className="flex items-center gap-2 cursor-pointer"
          onClick={() => navigate("/")}
        >
          <img src={logoPlain} alt="Logo" className="w-10 h-10 object-contain" />
          <div className="flex flex-col leading-tight">
            <span className="font-bold text-2xl bg-gradient-to-r from-orange-600 to-yellow-400 bg-clip-text text-transparent">
              ESAHAKARA
            </span>
            <span className="font-bold text-sm text-gray-600">Products</span>
          </div>
        </div>

        {/* Desktop Nav */}
        <div className="hidden md:flex items-center space-x-8 font-medium text-gray-700">
          <button onClick={() => navigate("/becomeaseller")} className="hover:text-orange-600">
            Sell Online
          </button>
          <button onClick={() => navigate("/feeandcom")} className="hover:text-orange-600">
            Fee and Commission
          </button>
          <button onClick={() => navigate("/grow")} className="hover:text-orange-600">
            Grow
          </button>
          <button onClick={() => navigate("/learn")} className="hover:text-orange-600">
            Learn
          </button>
        </div>

        {/* Desktop Buttons */}
        <div className="hidden md:flex items-center space-x-4">
          <button
            onClick={() => setLoginOpen(true)}
            className="bg-orange-500 hover:bg-orange-600 text-white font-semibold px-4 py-2 rounded-lg shadow"
          >
            Login
          </button>
          <button
            onClick={() => navigate("/startselling")}
            className="hover:text-orange-600 font-medium border border-orange-500 px-4 py-2 rounded-lg"
          >
            Start Selling
          </button>
        </div>

        {/* Mobile Menu Button */}
        <div className="md:hidden">
          <button
            onClick={() => setMenuOpen(!menuOpen)}
            className="text-2xl text-orange-600 focus:outline-none"
          >
            {menuOpen ? <FaTimes /> : <FaBars />}
          </button>
        </div>
      </nav>

      {/* Mobile Menu */}
      <div
        className={`md:hidden bg-white shadow-lg border-t border-gray-100 flex flex-col px-6 py-4 space-y-3 transition-all duration-300 ${
          menuOpen ? "max-h-screen opacity-100" : "max-h-0 opacity-0 overflow-hidden"
        }`}
      >
        {[
          { label: "Sell Online", path: "/becomeaseller" },
          { label: "Fee and Commission", path: "/feeandcom" },
          { label: "Grow", path: "/grow" },
          { label: "Learn", path: "/learn" },
        ].map((item) => (
          <button
            key={item.path}
            onClick={() => {
              navigate(item.path);
              setMenuOpen(false);
            }}
            className="hover:text-orange-600 text-left"
          >
            {item.label}
          </button>
        ))}

        <button
          onClick={() => {
            setLoginOpen(true);
            setMenuOpen(false);
          }}
          className="bg-orange-500 hover:bg-orange-600 text-white font-semibold px-4 py-2 rounded-lg shadow mt-2"
        >
          Login
        </button>
        <button
          onClick={() => {
            navigate("/startselling");
            setMenuOpen(false);
          }}
          className="hover:text-orange-600 font-medium border border-orange-500 px-4 py-2 rounded-lg"
        >
          Start Selling
        </button>
      </div>

      {/* Login Modal */}
      <LoginModal isOpen={loginOpen} onClose={() => setLoginOpen(false)} />

      {/* Page Content */}
      <main className="flex-1 p-6 md:p-10 space-y-6 overflow-y-auto">
        <h1 className="text-3xl font-bold mb-4 text-gray-900">
          Terms of Use & Privacy Policy
        </h1>

        <div className="text-gray-700 text-base leading-relaxed space-y-4">
          <p>
            This document is an electronic record in terms of Information Technology Act, 2000 (“IT Act, 2000”), the applicable rules thereunder and the provisions pertaining to electronic records in various statutes as amended by the Information Technology Act, 2000. This electronic record is generated by a computer system and does not require any physical or digital signatures.
          </p>

          <p>
            This document is published in accordance with the provisions of Rule 3 (1) of the Information Technology (Intermediary Guidelines and Digital Media Ethics Code) Rules, 2021 that require publishing the rules and regulations, privacy policy and Terms of Use for access to or usage of the E-Sahakara website.
          </p>

          <p>
            The domain name www.esahakara.com, including the related mobile site and mobile application as well as the Seller portal (seller.esahakara.com) (hereinafter referred to as “Platform”) is owned and operated by E-Sahakara Internet Private Limited (hereinafter referred to as 'E-Sahakara'), a company incorporated under the Companies Act, 1956, with its registered office at E-Sahakara Internet Private Limited, Buildings Alyssa, Begonia & Clove Embassy Tech Village, Outer Ring Road, Devarabeesanahalli Village, Bengaluru, 560103, Karnataka, India.
          </p>

          <p>
            For the purpose of the Terms of Use (hereinafter referred to as “ToU”), wherever the context so requires, ‘you’ and ‘your’ shall relate to any natural or legal person who has agreed to become a Seller on the Platform by providing registration data while registering on the Platform using computer systems. The word ‘user’ shall collectively imply a Seller, a Buyer, and any visitor on the Platform and the terms ‘we’, ‘us’ and ‘our’ shall mean E-Sahakara.
          </p>

          <p>
            Your use of the Platform and the features therein is governed by the following terms and conditions (ToU) including applicable policies available on the Platform, notifications and communications sent to you on the Platform which are incorporated herein by way of reference. If you transact on the Platform, you shall be subject to the policies that are applicable to the Platform for such a transaction. By mere use of the Platform you shall be contracting with E-Sahakara, and these terms and conditions including the policies constitute your binding obligations to E-Sahakara.
          </p>

          <p>
            When you use any current or future services provided by us through the Platform you will be subject to the rules, guidelines, policies, terms and conditions applicable to such services and they shall be deemed incorporated into the ToU and considered a part and parcel of the ToU. We reserve the right, at our sole discretion, to change, modify, add, or remove portions of the ToU at any time. We will notify you through any of the communication modes as mentioned in this ToU in case of any changes or updates to the ToU that materially impact your use of the Platform. Your continued use of the Platform following the changes or updates will mean that you accept and agree to the revisions. As long as you comply with the ToU, we grant you a personal, non-exclusive, non-transferable, and limited privilege to enter and use the Platform.
          </p>

          <p>
            ACCESSING, BROWSING, OR OTHERWISE USING THE PLATFORM INDICATES YOUR AGREEMENT WITH ALL THE TERMS AND CONDITIONS UNDER THE ToU. PLEASE READ THE ToU CAREFULLY BEFORE PROCEEDING. By implicitly or expressly accepting the ToU, you also accept and agree to be bound by all of E-Sahakara’s policies applicable to you, as amended, from time to time.
          </p>

          <h2 className="text-xl font-bold mt-4">Seller Eligibility</h2>
          <p>
            The use of the Platform is available only to persons who can form legally binding contracts under the Indian Contract Act, 1872. Persons who are "incompetent to contract" within the meaning of the Indian Contract Act, 1872, including minors, un-discharged insolvents etc. are not eligible to use the Platform. If you are a minor i.e. under the age of 18 years, you shall not register as a Seller on the Platform, transact or use the Platform. E-Sahakara reserves the right to terminate your registration and/or refuse you access to the Platform if it is brought to E-Sahakara’s notice or discovered that you are under the age of 18 years. If you register as a business entity, you represent that you are duly authorised by the business entity to accept the ToU and you have the authority to bind the business entity to the ToU.
          </p>

          <h2 className="text-xl font-bold mt-4">Your Account and Registration Obligations</h2>
          <p>
            In the course of your use of the Platform, you agree to furnish your details and information as requested by us from time to time including, but not limited to, the following information, to register as a Seller:
          </p>

          <ul className="list-disc ml-6 space-y-1">
            <li>Seller Complete Name</li>
            <li>Seller Complete Address</li>
            <li>Seller Complete Contact details</li>
            <li>Seller Grievance Officer details for Consumer Complaints</li>
            <li>Phone no.</li>
            <li>Email Address</li>
            <li>GSTIN</li>
            <li>PAN</li>
            <li>Business Pan</li>
            <li>Pincode</li>
            <li>Pick-up Address</li>
            <li>Registered Address - Principal geographic address of its headquarters and all branches</li>
            <li>Bank A/c Details</li>
            <li>Account Holder Name</li>
            <li>Cancelled Cheque</li>
            <li>Signature</li>
            <li>Display Legal Name</li>
            <li>Legal Name / Trade Name</li>
            <li>Contractual information (SLA)</li>
            <li>Total price in single figure of any goods / service (break up price / charges, if any)</li>
            <li>Relevant details of goods including Manufacturer / Packer / Name and Complete Address</li>
            <li>Relevant details of imported goods including Name and details of Importer with correct Country of Origin (Country’s full name)</li>
            <li>Relevant guarantee or warranties applicable to all goods / services you are selling on the platform.</li>
          </ul>

          <p>
            You agree that you have necessary licences and permits for the sale on the Platform which shall be including but not limited to the licences required by all applicable laws. You shall remain responsible for maintaining confidentiality of this information, as well as your display name, login and password details. You agree that if you provide any information which is untrue, inaccurate, not current, or incomplete or we have reasonable grounds to suspect that such information is untrue, inaccurate, not current, incomplete, or not in accordance with the ToU, we shall have the right to suspend or terminate your account on the Platform or indefinitely block you from accessing the Platform.
          </p>

          <h2 className="text-xl font-bold mt-4">Seller Account Deactivation</h2>
          <p>
            As per our policy, if a Seller requests for a closure of the account, the account will be put on hold for a period of 90 days to ensure smooth closure of transactions which have been made prior to his closure request and this will be available to the said Seller for downloading payment and taxation reports, if required. After 90 days, the Seller would be required to reach out to us confirming that he has downloaded the reports and requesting for a deactivation again. Upon receiving this confirmation, the Seller’s account will be deactivated provided there are no outstanding payments due from the Seller, with certain information being retained by E-Sahakara at all times, such as registered mobile number, registered email ID, GSTIN and other transaction related information.
          </p>

          <h2 className="text-xl font-bold mt-4">Communications</h2>
          <p>
            When you use the Platform or send emails, other data, information, or communication to us, you agree and understand that you are communicating with us through electronic records and you consent to receive communications via electronic records from us periodically or as and when required. We may communicate with you by email or any other mode of communication, electronic or otherwise.
          </p>

          <h2 className="text-xl font-bold mt-4">Platform for Transaction and Communication</h2>
          <p>
            The Platform is a platform that users utilise to independently meet and interact with one another for their transactions. E-Sahakara is not and cannot be a party to any transaction or dispute between users on the Platform.
          </p>

          <p>
            Consequently, all commercial / contractual terms are offered by you and agreed upon between you and Buyers alone. E-Sahakara does not determine, advise, have any control, or in any way involve itself in the offering or acceptance of such commercial / contractual terms between you and Buyers.
          </p>

          <p>
            E-Sahakara does not make any representations or warranties regarding specifics (such as quality, value, and saleability) of the products or services proposed to be sold, offered to be sold or purchased on the Platform. E-Sahakara does not implicitly or explicitly support or endorse the sale or purchase of any products and services on the Platform. E-Sahakara accepts no liability for any errors or omissions of third parties in relation to the products and services.
          </p>

          <p>
            E-Sahakara is not responsible for any non-performance or breach of any contract between you and Buyers. E-Sahakara cannot and does not guarantee that you and Buyers concerned will perform transaction(s) concluded on the Platform. E-Sahakara shall not and is not required to mediate or resolve disputes or disagreements between you and Buyers.
          </p>

          <p>
            E-Sahakara does not make any representations or warranties regarding item-specifics (such as legal title, creditworthiness, identity, etc.) of any of its users. You are advised to independently verify the bona fides of any particular Buyer you choose to deal with on the Platform and use your best judgement in that regard.
          </p>

          <p>
            E-Sahakara does not at any point in time during a transaction between you and a Buyer on the Platform come into or take possession of any of the products or services offered by you, gain title to or have any rights or claims over the products or services offered by you to the Buyer. At no time shall E-Sahakara hold any right / title to or interest in the items nor have any obligations or liabilities with respect to such a contract. The Platform is only a platform that can be utilised by you to reach a larger customer base to sell items or services. E-Sahakara only provides a platform for communication and it is agreed that the contract for sale of any products or services shall be a strictly bipartite contract between you and the Buyer.
          </p>

          <p>
            You release and indemnify E-Sahakara and / or any of its directors, officers and representatives from any cost, damage, liability or other consequence of any of the actions of the users on the Platform and specifically waive any claims that you may have in this behalf under any applicable law. Notwithstanding its reasonable efforts on that behalf, E-Sahakara cannot control the information provided by other users which is made available on the Platform. You may find other user's information to be offensive, harmful, inaccurate or deceptive. Please use caution and practise safe trading when using the Platform. Please note that there may be risks in dealing with underage persons or people acting under false pretence.
          </p>
        </div>
      </main>
    </div>
  );
};

export default TermsAndPolicy;
