import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import {
    faFacebookF,
    faWhatsapp,
    faInstagram,
    faLinkedinIn,
} from "@fortawesome/free-brands-svg-icons";
import { Link } from "react-router-dom";
import logo from "../../assets/images/logo_plain.png";

const Footer = () => {
    return (
        <footer className="bg-gray-900 text-gray-200 py-10">
            <div className="container mx-auto px-6 md:px-12 lg:px-24 flex flex-col md:flex-row justify-between gap-8">
                {/* ===== Logo & About ===== */}
                <div className="flex flex-col gap-4 md:w-1/4">
                    <Link to="/" className="flex items-center gap-2">
                        <img
                            className="w-10 h-10 object-contain"
                            src={logo}
                            alt="Esahakara"
                        />
                        <div className="flex flex-col">
                            <span className="font-bold text-2xl bg-gradient-to-r from-orange-600 to-yellow-400 bg-clip-text text-transparent">
                                ESAHAKARA
                            </span>
                            <span className="font-bold text-sm bg-gradient-to-r from-orange-600 to-yellow-400 bg-clip-text text-transparent">
                                Products
                            </span>
                        </div>
                    </Link>

                    {/* ===== Social Icons ===== */}
                    <div className="flex gap-4 mt-2">
                        <a
                            href="https://facebook.com"
                            target="_blank"
                            rel="noopener noreferrer"
                            className="hover:text-orange-500 transition-colors"
                        >
                            <FontAwesomeIcon icon={faFacebookF} />
                        </a>
                        <a
                            href="https://wa.me/919844635391"
                            target="_blank"
                            rel="noopener noreferrer"
                            className="hover:text-orange-500 transition-colors"
                        >
                            <FontAwesomeIcon icon={faWhatsapp} />
                        </a>
                        <a
                            href="https://instagram.com"
                            target="_blank"
                            rel="noopener noreferrer"
                            className="hover:text-orange-500 transition-colors"
                        >
                            <FontAwesomeIcon icon={faInstagram} />
                        </a>
                        <a
                            href="https://linkedin.com"
                            target="_blank"
                            rel="noopener noreferrer"
                            className="hover:text-orange-500 transition-colors"
                        >
                            <FontAwesomeIcon icon={faLinkedinIn} />
                        </a>
                    </div>
                </div>

                {/* ===== Quick Links ===== */}
                <div className="flex flex-col gap-2 md:w-1/4">
                    <h3 className="text-lg font-semibold mb-2">Quick Links</h3>
                    <Link to="/home" className="hover:text-orange-500 transition-colors">
                        Home
                    </Link>
                    <Link
                        to="/minutes"
                        className="hover:text-orange-500 transition-colors"
                    >
                        Minutes
                    </Link>
                    <Link
                        to="/mobiles"
                        className="hover:text-orange-500 transition-colors"
                    >
                        Mobiles & Tablets
                    </Link>
                    <Link
                        to="/electronics"
                        className="hover:text-orange-500 transition-colors"
                    >
                        Electronics
                    </Link>
                    <Link
                        to="/fashion"
                        className="hover:text-orange-500 transition-colors"
                    >
                        Fashion
                    </Link>
                </div>

                {/* ===== Customer Service ===== */}
                <div className="flex flex-col gap-2 md:w-1/4">
                    <h3 className="text-lg font-semibold mb-2">Customer Service</h3>
                    <Link to="/contact" className="hover:text-orange-500 transition-colors">
                        Contact Us
                    </Link>
                    <Link to="/faq" className="hover:text-orange-500 transition-colors">
                        FAQ
                    </Link>
                    <Link to="/returns" className="hover:text-orange-500 transition-colors">
                        Returns
                    </Link>
                    <Link to="/shipping" className="hover:text-orange-500 transition-colors">
                        Shipping
                    </Link>
                </div>

                {/* ===== Contact Info ===== */}
                <div className="flex flex-col gap-2 md:w-1/4">
                    <h3 className="text-lg font-semibold mb-2">Contact</h3>
                    <p className="text-sm hover:text-orange-500 transition-colors">
                        #166 & 167, 5th Cross, Bhuvaneswari Nagar, Near Manyata Tech Park,
                        Dasarahalli Main Road, Hebbal Farm Post, Bengaluru 560024
                    </p>
                    <p className="text-sm hover:text-orange-500 transition-colors">
                        Email: info@ttglobalit.in
                    </p>
                    <p className="text-sm hover:text-orange-500 transition-colors">
                        Phone: +91 98446 35391
                    </p>
                </div>
            </div>

            {/* ===== Bottom Bar ===== */}
            <div className="mt-10 border-t border-gray-700 pt-4 text-center text-sm">
                © {new Date().getFullYear()}{" "}
                <a
                    href="https://www.ttglobalit.com/"
                    target="_blank"
                    rel="noopener noreferrer"
                    className="text-orange-600 hover:underline"
                >
                    TT GLOBAL IT
                </a>{" "}
                . All rights reserved.
            </div>
        </footer>
    );
};

export default Footer;
