
import buyOffersImage from "../../assets/images/buy_1_get_1.jpg";

const Offers = () => {
  const offers = [
    {
      id: 1,
      title: "Buy 1 Get 1 Free",
      description: "On all t-shirts and casual wear - limited time only!",
      image: buyOffersImage,
      bgColor: "bg-pink-800",
    },
    {
      id: 2,
      title: "20% Off on First Order",
      description:
        "Sign up and enjoy exclusive discounts on your first purchase.",
      image: buyOffersImage,
      bgColor: "bg-yellow-800",
    },
    {
      id: 3,
      title: "New Collections Launched",
      description: "Discover our latest arrivals in Electronics.",
      image: buyOffersImage,
      bgColor: "bg-blue-800",
    },
    {
      id: 4,
      title: "Big Sale",
      description: "Up to 50% off across all categories!",
      image: buyOffersImage,
      bgColor: "bg-red-800",
    },
    {
      id: 5,
      title: "Big Sale",
      description: "Up to 50% off across all categories!",
      image: buyOffersImage,
      bgColor: "bg-red-800",
    },
    {
      id: 6,
      title: "Big Sale",
      description: "Up to 50% off across all categories!",
      image: buyOffersImage,
      bgColor: "bg-red-800",
    },
  ];

  return (
    <section className="py-10 px-4">
      <h2 className="text-2xl font-bold mb-6 text-center">Special Offers</h2>

      <div className="grid grid-cols-1 md:grid-cols-3 gap-6">
        {offers.map((offer) => (
          <div
            key={offer.id}
            className={`relative rounded-2xl overflow-hidden shadow-md hover:shadow-lg transition ${offer.bgColor}`}
          >
            <img
              src={offer.image}
              alt={offer.title}
              className="w-full h-48 object-cover opacity-90"
            />
            <div className="absolute inset-0 bg-black/40 flex flex-col justify-center items-center text-center text-white p-4">
              <h3 className="text-xl font-semibold">{offer.title}</h3>
              <p className="text-sm mt-2">{offer.description}</p>
              <button className="mt-3 bg-white text-black py-2 px-4 rounded-xl hover:bg-orange-400 cursor-pointer hover:text-white">
                Shop Now
              </button>
            </div>
          </div>
        ))}
      </div>
    </section>
  );
};

export default Offers;
