import { Swiper, SwiperSlide } from "swiper/react";
import { Navigation, Pagination, Autoplay } from "swiper/modules";
import "swiper/css";
import "swiper/css/navigation";
import "swiper/css/pagination";

import banner from "../../assets/images/banner.jpg";
import banner1 from "../../assets/images/banner1.jpg";
import banner2 from "../../assets/images/banner2.jpg";

const Slider = () => {
    const banners = [
        { id: 1, img: banner, alt: "Big Billion Days Offer" },
        { id: 2, img: banner1, alt: "Electronics Sale" },
        { id: 3, img: banner2, alt: "Fashion Discounts" },
    ];

    return (
        <div className="w-full overflow-hidden">
            <Swiper
                modules={[Navigation, Pagination, Autoplay]}
                spaceBetween={0}
                slidesPerView={1}
                navigation
                pagination={{ clickable: true }}
                autoplay={{ delay: 3000, disableOnInteraction: false }}
                loop={true}
                className="w-full h-[200px] sm:h-[300px] md:h-[400px] lg:h-[500px] xl:h-[350px]"
            >
                {banners.map((banner) => (
                    <SwiperSlide key={banner.id}>
                        <img
                            src={banner.img}
                            alt={banner.alt}
                            className="w-full h-full object-cover object-center cursor-pointer"
                            loading="lazy"
                        />
                    </SwiperSlide>
                ))}
            </Swiper>
        </div>
    );
};

export default Slider;
