// src/components/productPage/PaginationBar.jsx
import React from "react";
import { Button } from "@/components/ui/button";

const PaginationBar = ({ total, perPage, page, setPage }) => {
    const pages = Math.ceil(total / perPage);

    return (
        <div className="flex justify-center gap-2 mt-6">
            <Button
                disabled={page === 1}
                onClick={() => setPage(page - 1)}
                variant="outline"
            >
                Prev
            </Button>

            <Button variant="secondary">
                Page {page} / {pages}
            </Button>

            <Button
                disabled={page === pages}
                onClick={() => setPage(page + 1)}
                variant="outline"
            >
                Next
            </Button>
        </div>
    );
};

export default PaginationBar;
