import ProductCard from "./ProductCard";
import ProductSkeleton from "./ProductSkeleton";

const ProductGrid = ({ products, loading, onQuickView }) => {
    if (loading) {
        return (
            <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 p-4 justify-items-center">
                {Array.from({ length: 8 }).map((_, i) => (
                    <ProductSkeleton key={i} />
                ))}
            </div>
        );
    }

    if (products.length === 0) {
        return (
            <div className="flex flex-col items-center text-center p-10 mx-auto">
                <img src="/empty-box.gif" className="w-48 h-48 opacity-80" />
                <h2 className="text-xl font-semibold text-gray-700 mt-4">
                    No Products Found
                </h2>
                <p className="text-gray-500 text-sm mt-2">
                    Try adjusting your filters or searching another category.
                </p>
            </div>
        );
    }

    return (
        <div className="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-4 gap-4 p-4 justify-items-center">
            {products.map((p) => (
                <ProductCard key={p._id} product={p} onQuickView={onQuickView} />
            ))}
        </div>
    );
};

export default ProductGrid;
