import React from "react";
import { Dialog, DialogContent } from "@/components/ui/dialog";

const QuickViewModal = ({ product, onClose }) => {
    const API_URL = import.meta.env.VITE_API_URL;

    if (!product) return null;

    return (
        <Dialog open={!!product} onOpenChange={onClose}>
            <DialogContent className="max-w-2xl bg-white p-6">
                <div className="grid grid-cols-1 sm:grid-cols-2 gap-6">

                    <img
                        src={`${API_URL}${product.media?.[0]?.url}`}
                        className="w-full h-64 object-contain rounded"
                    />

                    <div>
                        <h2 className="text-xl font-semibold">{product.name}</h2>
                        <p className="text-gray-600 mt-2">
                            {product.description?.replace(/<[^>]+>/g, "")}
                        </p>

                        <div className="text-2xl font-bold mt-4">
                            ₹{product.price}
                        </div>

                        <button className="mt-5 bg-orange-500 text-white px-4 py-2 rounded">
                            Add to Cart
                        </button>
                    </div>

                </div>
            </DialogContent>
        </Dialog>
    );
};

export default QuickViewModal;