// src/components/productPage/SortBar.jsx
import React from "react";
import { Select, SelectTrigger, SelectContent, SelectItem } from "@/components/ui/select";

const SortBar = ({ sortBy, setSortBy }) => {
    return (
        <div className="flex justify-between items-center bg-white p-3 rounded-lg shadow-sm ">
            <p className="text-sm text-gray-700">Sort By</p>

            <Select value={sortBy} onValueChange={setSortBy}>
                <SelectTrigger className="w-40">
                    <span className="text-sm capitalize">{sortBy}</span>
                </SelectTrigger>

                <SelectContent>
                    <SelectItem value="relevance">Relevance</SelectItem>
                    <SelectItem value="low-high">Price: Low → High</SelectItem>
                    <SelectItem value="high-low">Price: High → Low</SelectItem>
                    <SelectItem value="newest">Newest First</SelectItem>
                    <SelectItem value="az">A → Z</SelectItem>
                </SelectContent>
            </Select>
        </div>
    );
};

export default SortBar;
