import React from 'react'

const SingleProductSkeleton = () => {
    return (
        <div className='flex flex-col md:flex-row gap-8 animate-pulse'>
            {/* Left : image section */}
            <div className='flex flex-col gap-4 flex-1'>
                {/* Main Image */}
                <div className='w-full h-[420px] bg-gray-200 rounded-xl'>

                </div>

                {/* Image thumbnails */}
                <div className='flex gap-2 overflow-x-auto'>
                    <div className='w-20 h-20 bg-gray-200 rounded-lg'></div>
                    <div className='w-20 h-20 bg-gray-200 rounded-lg'></div>
                    <div className='w-20 h-20 bg-gray-200 rounded-lg'></div>
                    <div className='w-20 h-20 bg-gray-200 rounded-lg'></div>
                </div>

                {/* Add to cart / Buy now buttons */}
                <div className='flex gap-3 mt-6'>
                    <button className='bg-orange-500 hover:bg-orange-600 text-white py-8 px-4 rounded flex-1 text-2xl'>
                        Add to Cart
                    </button>
                    <button className='bg-orange-500 hover:bg-orange-600 text-white py-8 px-4 rounded flex-1 text-2xl'>
                        Buy Now
                    </button>
                </div>

            </div>

            {/* Right : product details section */}
            <div className='flex flex-col gap-4 flex-1'>
                {/* Title */}
                <div className='w-full h-12 bg-gray-200 rounded-lg'></div>

                {/* Price Section */}
                <div className='w-full h-12 bg-gray-200 rounded-lg'></div>

                {/* Stock Info */}
                <div className='w-full h-12 bg-gray-200 rounded-lg'></div>

                {/* Description */}
                <div className='w-full h-24 bg-gray-200 rounded-lg'></div>

                {/* Additional Info Sections */}
                <div className='w-full h-24 bg-gray-200 rounded-lg'></div>

                {/* Free Delivery */}
                <div className='w-full h-12 bg-gray-200 rounded-lg'></div>

                {/* Save amount */}
                <div className='w-full h-12 bg-gray-200 rounded-lg'></div>

                {/* Ribbon */}
                <div className='w-full h-12 bg-gray-200 rounded-lg'></div>
            </div>

        </div>
    )
}

export default SingleProductSkeleton