import mongoose from "mongoose";

const userSchema = new mongoose.Schema({
    userName: {
        type: String,
        required: true
    },
    email: {
        type: String,
        required: true,
        unique: true
    },
    password: {
        type: String,
        required: true
    },
    token: {
        type: String,
        default: ''
    }, 
}, { minimize: false })

const userModel = mongoose.models.User || mongoose.model('User', userSchema)
export default userModel;