import { useState } from "react";

export default function AdminVendors() {
    const [vendors, setVendors] = useState([]);
    const [formData, setFormData] = useState({ name: "", phone: "" });
    const [otp, setOtp] = useState("");
    const [generatedOtp, setGeneratedOtp] = useState(null);
    const [step, setStep] = useState(1);

    const handleChange = (e) => setFormData({ ...formData, [e.target.name]: e.target.value });

    const handleSignup = (e) => {
        e.preventDefault();
        if (!formData.name || !formData.phone) return alert("Fill all fields");
        const newOtp = Math.floor(100000 + Math.random() * 900000).toString();
        console.log("OTP:", newOtp);
        setGeneratedOtp(newOtp);
        setStep(2);
    };

    const verifyOtp = () => {
        if (otp === generatedOtp) {
            setVendors([...vendors, formData]);
            setFormData({ name: "", phone: "" });
            setStep(1);
            alert("Vendor added successfully");
        } else alert("Incorrect OTP");
    };

    return (
        <div>
            <h1 className="text-2xl font-semibold mb-6">Vendor Onboarding</h1>

            {step === 1 && (
                <form onSubmit={handleSignup} className="bg-white p-6 rounded-lg shadow-md space-y-4 mb-6">
                    <input type="text" name="name" placeholder="Vendor Name" value={formData.name} onChange={handleChange} className="border rounded p-2 w-full" />
                    <input type="text" name="phone" placeholder="Phone Number" value={formData.phone} onChange={handleChange} className="border rounded p-2 w-full" />
                    <button type="submit" className="bg-blue-600 text-white px-6 py-2 rounded hover:bg-blue-700">Send OTP</button>
                </form>
            )}

            {step === 2 && (
                <div className="bg-white p-6 rounded-lg shadow-md space-y-4 mb-6">
                    <input type="text" placeholder="Enter OTP" value={otp} onChange={(e) => setOtp(e.target.value)} className="border rounded p-2 w-full" />
                    <button onClick={verifyOtp} className="bg-green-600 text-white px-6 py-2 rounded hover:bg-green-700">Verify OTP</button>
                </div>
            )}

            <div className="bg-white p-6 rounded-lg shadow-md">
                <h2 className="text-lg font-semibold mb-4">Vendors List</h2>
                <table className="min-w-full">
                    <thead className="bg-gray-200 text-gray-600 uppercase text-sm">
                        <tr><th>Name</th><th>Phone</th></tr>
                    </thead>
                    <tbody>
                        {vendors.map((v, idx) => (
                            <tr key={idx} className="border-b hover:bg-gray-50">
                                <td className="py-3 px-6">{v.name}</td>
                                <td className="py-3 px-6">{v.phone}</td>
                            </tr>
                        ))}
                    </tbody>
                </table>
            </div>
        </div>
    );
}
