import { Link } from 'react-router-dom';

export default function Breadcrumbs({ paths }) {
    return (
        <nav className="text-sm text-gray-500 mb-4">
            {paths.map((path, index) => (
                <span key={index}>
                    {index > 0 && <span className="mx-1">{' > '}</span>}
                    {path.to ? (
                        <Link to={path.to} className="hover:text-orange-500">
                            {path.label}
                        </Link>
                    ) : (
                        <span className="text-gray-900">{path.label}</span>
                    )}
                </span>
            ))}
        </nav>
    );
}
