import express from 'express'
import cors from 'cors'
import { connectDB } from './config/db.js'
import dotenv from 'dotenv';
import cookieParser from 'cookie-parser';
import userRoute from './routes/userRoute.js';
import adminRoute from './routes/adminRoute.js';

dotenv.config()

// app config
const app = express()
const port = process.env.PORT || 9000

//middleware
app.use(express.json())
app.use(express.urlencoded({ extended: true }));
app.use(cookieParser())
app.use(cors({
    origin: "http://128.199.24.208:5173", // Vite frontend
    methods: ['GET', 'POST', 'PUT', 'DELETE'],
    credentials: true,               // allow cookies / credentials
}));

// api endpoint
app.use('/api', userRoute,adminRoute)


app.get('/',(req,res)=> {
    res.send("Hello")
})

app.listen(port, () => {
    connectDB()
    console.log(`server started on http://localhost:${port}`)
})
