import { useState } from "react";

export default function AdminUsers() {
    const [users, setUsers] = useState([
        { id: 1, name: "John Doe", email: "john@example.com", role: "Customer", status: "Active" },
        { id: 2, name: "Jane Smith", email: "jane@example.com", role: "Vendor", status: "Blocked" },
    ]);

    const toggleStatus = (id) => {
        setUsers((prev) =>
            prev.map((user) =>
                user.id === id
                    ? { ...user, status: user.status === "Active" ? "Blocked" : "Active" }
                    : user
            )
        );
    };

    return (
        <div>
            <h1 className="text-2xl font-semibold mb-6">User Management</h1>
            <div className="bg-white p-6 rounded-lg shadow-md">
                <table className="min-w-full">
                    <thead className="bg-gray-200 text-gray-600 uppercase text-sm">
                        <tr>
                            <th className="py-3 px-6 text-left">Name</th>
                            <th className="py-3 px-6 text-left">Email</th>
                            <th className="py-3 px-6 text-left">Role</th>
                            <th className="py-3 px-6 text-left">Status</th>
                            <th className="py-3 px-6 text-center">Actions</th>
                        </tr>
                    </thead>
                    <tbody className="text-gray-700">
                        {users.map((user) => (
                            <tr key={user.id} className="border-b border-gray-200 hover:bg-gray-50">
                                <td className="py-3 px-6">{user.name}</td>
                                <td className="py-3 px-6">{user.email}</td>
                                <td className="py-3 px-6">{user.role}</td>
                                <td className="py-3 px-6">{user.status}</td>
                                <td className="py-3 px-6 text-center">
                                    <button
                                        onClick={() => toggleStatus(user.id)}
                                        className={`px-3 py-1 rounded text-white ${user.status === "Active"
                                                ? "bg-red-500 hover:bg-red-600"
                                                : "bg-green-500 hover:bg-green-600"
                                            }`}
                                    >
                                        {user.status === "Active" ? "Block" : "Activate"}
                                    </button>
                                </td>
                            </tr>
                        ))}
                    </tbody>
                </table>
            </div>
        </div>
    );
}
