import { FontAwesomeIcon } from "@fortawesome/react-fontawesome";
import { faFacebookF, faWhatsapp , faInstagram, faLinkedinIn } from "@fortawesome/free-brands-svg-icons";
import { Link } from "react-router-dom";
import logo from '../../assets/images/logo_plain.png'

const Footer = () => {
    return (
        <footer className="bg-gray-900 text-gray-200 py-10">
            <div className=" container mx-auto px-6 md:px-12 lg:px-24 flex flex-col md:flex-row justify-between gap-8">
                {/* logo % about */}
                <div className="flex flex-col gap-4 md:w-1/4">
                    <Link to ="/" className="flex items-center gap-2">
                        <img className="w-10 h-10 object-contain" src={logo} alt="Esahakara" />
                        <div className="flex flex-col">
                            <span className="font-bold text-2xl bg-gradient-to-r from-orange-600 to-yellow-400 bg-clip-text text-transparent">
                                ESAHAKARA
                            </span>
                            <span className="font-bold text-sm bg-gradient-to-r from-orange-600 to-yellow-400 bg-clip-text text-transparent">
                                Products
                            </span>
                        </div>
                    </Link>
                    <div className="flex gap-4 mt-2">
                        <a href="#" className="hover:text-orange-500">
                            <FontAwesomeIcon icon={faFacebookF} />
                        </a>
                        <a href="#" className="hover:text-orange-500">
                            <FontAwesomeIcon icon={faWhatsapp } />
                        </a>
                        <a href="#" className="hover:text-orange-500">
                            <FontAwesomeIcon icon={faInstagram} />
                        </a>
                        <a href="#" className="hover:text-orange-500">
                            <FontAwesomeIcon icon={faLinkedinIn} />
                        </a>
                    </div>
                </div>

                {/* Quick links */}
                <div className="flex flex-col gap-2 md:w-1/4">
                    <h3 className="text-lg font-semibold mb-2">Quick Links</h3>
                    <Link to="/home" className="hover:text-orange-500">
                        Home
                    </Link>
                    <Link to="/minutes" className="hover:text-orange-500">
                        Minutes
                    </Link>
                    <Link to="/mobiles" className="hover:text-orange-500">
                        Mobiles & Tablets
                    </Link>
                    <Link to="/electronics" className="hover:text-orange-500">
                        Electronics
                    </Link>
                    <Link to="/fashion" className="hover:text-orange-500">
                        Fashion
                    </Link>
                </div>

                {/* Customer Service */}
                <div className="flex flex-col gap-2 md:w-1/4">
                    <h3 className="text-lg font-semibold mb-2">Customer Service</h3>
                    <Link to='/contact'>Contact Us</Link>
                    <Link to='/faq'>FAQ</Link>
                    <Link to='/returns'>Retuns</Link>
                    <Link to='/shipping'>Shipping</Link>
                </div>

                {/* Contact Info */}
                <div className="flex flex-col gap-2 md:w-1/4 cursor-pointer">
                    <h3 className="text-lg font-semibold mb-2">Contact</h3>
                    <p className="text-sm hover:text-orange-500">#166&167 5th Cross Bhuvaneswari Nagar Near Manayatha Tech Park Dasarahalli Main Road Hebbal Farm Post Bengaluru 560024</p>
                    <p className="text-sm hover:text-orange-500">Email: info@ttglobalit.in</p>
                    <p className="text-sm hover:text-orange-500">Phone: +91 9844635391</p>
                </div>
            </div>

            {/* Bottom Bar */}
            <div className="mt-10 border-t border-gray-700 pt-4 text-center text-sm cursor-pointer">
                © {new Date().getFullYear()} <a href="https://www.ttglobalit.com/" className="text-orange-600">TT GLOBAL IT</a> . All rights reserved.
            </div>
        </footer>
    );
};

export default Footer;
