import { defineConfig } from 'vite'
import react from '@vitejs/plugin-react'
import tailwindcss from '@tailwindcss/vite'

export default defineConfig({
  plugins: [react(), tailwindcss()],
  server: {
    host: true,
    port: 5173,
    proxy: {
      '/api': {
        target: 'http://128.199.24.208:5000', // Changed to HTTP
        changeOrigin: true,
        secure: false,
        rewrite: (path) => path, // Keep the /api path as is
      }
    }
  },
})
