import { useNavigate } from "react-router-dom";
import { useEffect, useState } from "react";

const BASE_URL = import.meta.env.VITE_BASE_URL;

export default function AdminNavbar() {
    const navigate = useNavigate();
    const [adminName, setAdminName] = useState("Admin");

    useEffect(() => {
        // Get admin name from localStorage if available
        const name = localStorage.getItem("adminName");
        if (name) setAdminName(name);
    }, []);

    const handleLogout = async () => {
        try {
            await fetch(`${BASE_URL}/api/adminlogout`, {
                method: "POST",
                credentials: "include",
            });

            localStorage.removeItem("adminToken");
            localStorage.removeItem("adminName");

            navigate("/admin/login");
        } catch (error) {
            alert("Logout failed");
        }
    };

    return (
        <nav className="bg-white shadow-md py-4 px-6 flex justify-between items-center">
            {/* Left side: Dynamic Greeting */}
            <div className="flex items-center space-x-3">
                <span className="text-gray-700 font-medium text-lg">
                    Hello, {adminName} 👋
                </span>
            </div>

            {/* Right side: Logout */}
            <div>
                <button
                    onClick={handleLogout}
                    className="bg-orange-600 text-white py-2 px-4 rounded-lg hover:bg-orange-500 transition duration-200 font-semibold text-sm"
                >
                    Logout
                </button>
            </div>
        </nav>
    );
}
