import { useState } from "react";

export default function AdminOrders() {
  const [orders, setOrders] = useState([
    { id: 1001, customer: "John Doe", total: 250.75, date: "2025-10-18", status: "Pending" },
    { id: 1002, customer: "Jane Smith", total: 499.99, date: "2025-10-17", status: "Shipped" },
    { id: 1003, customer: "Mark Wilson", total: 89.0, date: "2025-10-16", status: "Delivered" },
  ]);

  const updateStatus = (id, newStatus) => {
    setOrders((prev) =>
      prev.map((order) =>
        order.id === id ? { ...order, status: newStatus } : order
      )
    );
  };

  return (
    <div>
      <h1 className="text-2xl font-semibold mb-6">Order Management</h1>
      <div className="bg-white p-6 rounded-lg shadow-md">
        <table className="min-w-full">
          <thead className="bg-gray-200 text-gray-600 uppercase text-sm">
            <tr>
              <th className="py-3 px-6 text-left">Order ID</th>
              <th className="py-3 px-6 text-left">Customer</th>
              <th className="py-3 px-6 text-left">Total</th>
              <th className="py-3 px-6 text-left">Date</th>
              <th className="py-3 px-6 text-left">Status</th>
              <th className="py-3 px-6 text-center">Actions</th>
            </tr>
          </thead>
          <tbody className="text-gray-700">
            {orders.map((order) => (
              <tr key={order.id} className="border-b border-gray-200 hover:bg-gray-50">
                <td className="py-3 px-6">{order.id}</td>
                <td className="py-3 px-6">{order.customer}</td>
                <td className="py-3 px-6">${order.total.toFixed(2)}</td>
                <td className="py-3 px-6">{order.date}</td>
                <td className="py-3 px-6">{order.status}</td>
                <td className="py-3 px-6 text-center space-x-2">
                  {order.status === "Pending" && (
                    <>
                      <button
                        onClick={() => updateStatus(order.id, "Shipped")}
                        className="bg-blue-500 text-white px-3 py-1 rounded hover:bg-blue-600"
                      >
                        Mark Shipped
                      </button>
                      <button
                        onClick={() => updateStatus(order.id, "Cancelled")}
                        className="bg-red-500 text-white px-3 py-1 rounded hover:bg-red-600"
                      >
                        Cancel
                      </button>
                    </>
                  )}
                  {order.status === "Shipped" && (
                    <button
                      onClick={() => updateStatus(order.id, "Delivered")}
                      className="bg-green-500 text-white px-3 py-1 rounded hover:bg-green-600"
                    >
                      Mark Delivered
                    </button>
                  )}
                </td>
              </tr>
            ))}
          </tbody>
        </table>
      </div>
    </div>
  );
}
