import { useNavigate } from "react-router-dom";
import minutes from "../../assets/images/quickcommerce.png"
import mobiles from "../../assets/images/mobiles.png";
import beautytoys from "../../assets/images/beauty.png";
import electronics from "../../assets/images/electronis2.png";
import fashion from "../../assets/images/fashion2.png";
import agro from "../../assets/images/agro.png";
import furniture from "../../assets/images/furniture2.png";
import grocery from "../../assets/images/grocery2.png";
import homekitchen from "../../assets/images/home.png";
import tvappliances from "../../assets/images/tv_appliances2.png";

const categories = [
  { name: "Minutes", icon: minutes, link: "/minutes" },
  { name: "Mobiles & Tablets", icon: mobiles, link: "/mobiles" },
  { name: "TVs & Appliances", icon: tvappliances, link: "/tvs" },
  { name: "Electronics", icon: electronics, link: "/electronics" },
  { name: "Fashion", icon: fashion, link: "/fashion" },
  { name: "Home & Kitchen", icon: homekitchen, link: "/home" },
  { name: "Beauty & Toys", icon: beautytoys, link: "/beauty" },
  { name: "Furniture", icon: furniture, link: "/furniture" },
  { name: "Agro Products", icon: agro, link: "/agro" },
  { name: "Grocery", icon: grocery, link: "/grocery" },
];

const Categories = () => {
  const navigate = useNavigate();

  return (
    <div className="w-full bg-white py-5">
      {/* Scrollable below 1024px, fixed full row at ≥1024px */}
      <div className="flex flex-row gap-7 px-8 sm:px-14 overflow-x-auto lg:overflow-x-visible flex-nowrap scrollbar-hide">
        {categories.map((item, index) => (
          <div
            key={index}
            onClick={() => navigate(item.link)}
            className="flex flex-col items-center text-center cursor-pointer min-w-[80px] lg:min-w-0"
          >
            <img
              src={item.icon}
              alt={item.name}
              className="w-14 h-14 sm:w-16 sm:h-16 md:w-20 md:h-20 rounded-lg object-contain"
            />
            <p className="mt-1 text-[10px] sm:text-sm md:text-base text-gray-800 leading-tight truncate w-full">
              {item.name}
            </p>
          </div>
        ))}
      </div>
    </div>
  );
};

export default Categories;
