import { BrowserRouter as Router, Routes, Route, useLocation } from "react-router-dom";
import { AuthProvider } from "./context/AuthContext";
import { Toaster } from "react-hot-toast";

// Public site components
import Navbar from "./components/Navbar/Navbar";
import Categories from "./components/Categories/Categories";
import Slider from "./components/Slider/Slider";
import Offers from "./components/Offers/Offers";
import Footer from "./components/Footer/Footer";
import LoginPage from "./components/LoginPage/LoginPage";
import BecomeASeller from "./components/BecomeASeller/BecomeASeller";
import Profile from "./components/Profile/Profile";

// Admin components
import AdminLogin from "./admin/auth/AdminLogin";
import AdminLayout from "./admin/components/AdminLayout";
import AdminDashboard from "./admin/pages/AdminDashboard";
import AdminOrders from "./admin/pages/AdminOrders";
import AdminUsers from "./admin/pages/AdminUsers";
import AdminVendors from "./admin/pages/AdminVendors";

// Admin Catalog pages
import Products from "./admin/pages/Catalog/products/Products";
import Inventory from "./admin/pages/Catalog/Inventory";
import BackInStock from "./admin/pages/Catalog/BackInStock";
import CatalogCategories from "./admin/pages/Catalog/Categories";
import DropShipping from "./admin/pages/Catalog/DropShipping";
import ImportProducts from "./admin/pages/Catalog/products/ImportProducts";


// -------------------
// App Content
// -------------------
const AppContent = () => {
  const location = useLocation();

  // Hide Navbar on BecomeASeller and all admin pages
  const hideNavbar =
    location.pathname === "/becomeaseller" ||
    location.pathname.startsWith("/admin");

  return (
    <>
      {!hideNavbar && <Navbar />}

      <Routes>
        {/* ---------------- PUBLIC ROUTES ---------------- */}
        <Route
          path="/"
          element={
            <>
              <Categories />
              <Slider />
              <Offers />
            </>
          }
        />
        <Route path="/userlogin" element={<LoginPage />} />
        <Route path="/usersignup" element={<LoginPage />} />
        <Route path="/becomeaseller" element={<BecomeASeller />} />
        <Route path="/userprofile" element={<Profile />} />

        {/* ---------------- ADMIN ROUTES ---------------- */}
        <Route path="/admin/login" element={<AdminLogin />} />

        {/* All other admin pages go under AdminLayout */}
        <Route path="/admin" element={<AdminLayout />}>
          {/* Dashboard, Orders, Users, Vendors */}
          <Route path="dashboard" element={<AdminDashboard />} />
          <Route path="orders" element={<AdminOrders />} />
          <Route path="users" element={<AdminUsers />} />
          <Route path="vendors" element={<AdminVendors />} />

          {/* Catalog Subroutes */}
          <Route path="products">
            <Route index element={<Products />} />
            <Route path="import" element={<ImportProducts />} />
          </Route>
          <Route path="inventory" element={<Inventory />} />
          <Route path="categories" element={<CatalogCategories />} />
          <Route path="back-in-stock" element={<BackInStock />} />
          <Route path="dropshipping" element={<DropShipping />} />
        </Route>
      </Routes>

      <Footer />
    </>
  );
};

// -------------------
// Main App
// -------------------
const App = () => {
  return (
    <AuthProvider>
      <Router>
        <Toaster position="top-right" reverseOrder={false} />
        <AppContent />
      </Router>
    </AuthProvider>
  );
};

export default App;
